//Bayer Ordered dithering
varying vec4 v_position;


uniform sampler2D texture;
vec3 packFloatToVec3i(const float value)
{
   const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
   const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
   vec3 res = fract(value * bitSh);
   res -= res.xxy * bitMsk;
   return res;
}

void main()
{
int draw = 0;
vec4 color = texture2D(texture, gl_TexCoord[0].xy).rgba;
color.rgb *= vec3(color.a);
vec3 luminosity = vec3(0.30, 0.59, 0.11);
float lum = dot(luminosity, color);

vec4 levels = vec4(0.9,0.75,0.5,0.25);
levels = levels/vec4(10);
float v = gl_FragCoord.s;
float h = gl_FragCoord.t;
float value;

float col = 1;
gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);

if (lum < levels.r) 
{
value = float(int((fract(v/2.0))+(fract(h/2.0))));
col *= value;
}

if (lum < levels.g) 
{
value = float(int((fract(v+v/2.0))+(fract(h+h/2.0))));
col *= value;
}

if (lum < levels.b) 
{
value = float(int((fract(v+v+v/2.0))+(fract(h+h/2.0))));
col *= value;
}

if (lum < levels.a) 
{
value = float(int((fract(v+v/2.0))+(fract(h+h+h/2.0))));
col *= value;
} 


if(col>0.9)
   gl_FragColor=vec4(packFloatToVec3i(length(v_position)/500.0),1);
else
discard;

}